package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  Email,
  Description,
  ClientToken,
  Name,
  ARN,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdatePortalRequest(
    portalId: ID,
    portalName: Name,
    portalDescription: Option[Description] = None,
    portalContactEmail: Email,
    portalLogoImage: Option[zio.aws.iotsitewise.model.Image] = None,
    roleArn: ARN,
    clientToken: Option[ClientToken] = None,
    notificationSenderEmail: Option[Email] = None,
    alarms: Option[zio.aws.iotsitewise.model.Alarms] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest = {
    import UpdatePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .portalName(Name.unwrap(portalName): java.lang.String)
      .optionallyWith(
        portalDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.portalDescription)
      .portalContactEmail(Email.unwrap(portalContactEmail): java.lang.String)
      .optionallyWith(portalLogoImage.map(value => value.buildAwsValue()))(
        _.portalLogoImage
      )
      .roleArn(ARN.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        notificationSenderEmail.map(value =>
          Email.unwrap(value): java.lang.String
        )
      )(_.notificationSenderEmail)
      .optionallyWith(alarms.map(value => value.buildAwsValue()))(_.alarms)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdatePortalRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdatePortalRequest.wrap(buildAwsValue())
}
object UpdatePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdatePortalRequest =
      zio.aws.iotsitewise.model.UpdatePortalRequest(
        portalId,
        portalName,
        portalDescription.map(value => value),
        portalContactEmail,
        portalLogoImage.map(value => value.asEditable),
        roleArn,
        clientToken.map(value => value),
        notificationSenderEmail.map(value => value),
        alarms.map(value => value.asEditable)
      )
    def portalId: ID
    def portalName: Name
    def portalDescription: Option[Description]
    def portalContactEmail: Email
    def portalLogoImage: Option[zio.aws.iotsitewise.model.Image.ReadOnly]
    def roleArn: ARN
    def clientToken: Option[ClientToken]
    def notificationSenderEmail: Option[Email]
    def alarms: Option[zio.aws.iotsitewise.model.Alarms.ReadOnly]
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getPortalName: ZIO[Any, Nothing, Name] = ZIO.succeed(portalName)
    def getPortalDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("portalDescription", portalDescription)
    def getPortalContactEmail: ZIO[Any, Nothing, Email] =
      ZIO.succeed(portalContactEmail)
    def getPortalLogoImage
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Image.ReadOnly] =
      AwsError.unwrapOptionField("portalLogoImage", portalLogoImage)
    def getRoleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(roleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNotificationSenderEmail: ZIO[Any, AwsError, Email] = AwsError
      .unwrapOptionField("notificationSenderEmail", notificationSenderEmail)
    def getAlarms
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
  ) extends zio.aws.iotsitewise.model.UpdatePortalRequest.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val portalName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.portalName())
    override val portalDescription: Option[Description] = scala
      .Option(impl.portalDescription())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val portalContactEmail: Email =
      zio.aws.iotsitewise.model.primitives.Email(impl.portalContactEmail())
    override val portalLogoImage
        : Option[zio.aws.iotsitewise.model.Image.ReadOnly] = scala
      .Option(impl.portalLogoImage())
      .map(value => zio.aws.iotsitewise.model.Image.wrap(value))
    override val roleArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.roleArn())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val notificationSenderEmail: Option[Email] = scala
      .Option(impl.notificationSenderEmail())
      .map(value => zio.aws.iotsitewise.model.primitives.Email(value))
    override val alarms: Option[zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      scala
        .Option(impl.alarms())
        .map(value => zio.aws.iotsitewise.model.Alarms.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdatePortalRequest
  ): zio.aws.iotsitewise.model.UpdatePortalRequest.ReadOnly = new Wrapper(impl)
}
