package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, Description, Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateAssetModelRequest(
    assetModelId: ID,
    assetModelName: Name,
    assetModelDescription: Option[Description] = None,
    assetModelProperties: Option[
      Iterable[zio.aws.iotsitewise.model.AssetModelProperty]
    ] = None,
    assetModelHierarchies: Option[
      Iterable[zio.aws.iotsitewise.model.AssetModelHierarchy]
    ] = None,
    assetModelCompositeModels: Option[
      Iterable[zio.aws.iotsitewise.model.AssetModelCompositeModel]
    ] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest = {
    import UpdateAssetModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest
      .builder()
      .assetModelId(ID.unwrap(assetModelId): java.lang.String)
      .assetModelName(Name.unwrap(assetModelName): java.lang.String)
      .optionallyWith(
        assetModelDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.assetModelDescription)
      .optionallyWith(
        assetModelProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelProperties)
      .optionallyWith(
        assetModelHierarchies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelHierarchies)
      .optionallyWith(
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.assetModelCompositeModels)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.UpdateAssetModelRequest.ReadOnly =
    zio.aws.iotsitewise.model.UpdateAssetModelRequest.wrap(buildAwsValue())
}
object UpdateAssetModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.UpdateAssetModelRequest =
      zio.aws.iotsitewise.model.UpdateAssetModelRequest(
        assetModelId,
        assetModelName,
        assetModelDescription.map(value => value),
        assetModelProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetModelHierarchies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        assetModelCompositeModels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def assetModelId: ID
    def assetModelName: Name
    def assetModelDescription: Option[Description]
    def assetModelProperties
        : Option[List[zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly]]
    def assetModelHierarchies
        : Option[List[zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly]]
    def assetModelCompositeModels: Option[
      List[zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly]
    ]
    def clientToken: Option[ClientToken]
    def getAssetModelId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetModelId)
    def getAssetModelName: ZIO[Any, Nothing, Name] = ZIO.succeed(assetModelName)
    def getAssetModelDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("assetModelDescription", assetModelDescription)
    def getAssetModelProperties: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assetModelProperties", assetModelProperties)
    def getAssetModelHierarchies: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly
    ]] =
      AwsError.unwrapOptionField("assetModelHierarchies", assetModelHierarchies)
    def getAssetModelCompositeModels: ZIO[Any, AwsError, List[
      zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "assetModelCompositeModels",
      assetModelCompositeModels
    )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest
  ) extends zio.aws.iotsitewise.model.UpdateAssetModelRequest.ReadOnly {
    override val assetModelId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetModelId())
    override val assetModelName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.assetModelName())
    override val assetModelDescription: Option[Description] = scala
      .Option(impl.assetModelDescription())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val assetModelProperties
        : Option[List[zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly]] =
      scala
        .Option(impl.assetModelProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.AssetModelProperty.wrap(item)
          }.toList
        )
    override val assetModelHierarchies
        : Option[List[zio.aws.iotsitewise.model.AssetModelHierarchy.ReadOnly]] =
      scala
        .Option(impl.assetModelHierarchies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsitewise.model.AssetModelHierarchy.wrap(item)
          }.toList
        )
    override val assetModelCompositeModels: Option[
      List[zio.aws.iotsitewise.model.AssetModelCompositeModel.ReadOnly]
    ] = scala
      .Option(impl.assetModelCompositeModels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsitewise.model.AssetModelCompositeModel.wrap(item)
        }.toList
      )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.UpdateAssetModelRequest
  ): zio.aws.iotsitewise.model.UpdateAssetModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
