package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Offset, Interval}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TumblingWindow(
    interval: Interval,
    offset: Option[Offset] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.TumblingWindow = {
    import TumblingWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.TumblingWindow
      .builder()
      .interval(Interval.unwrap(interval): java.lang.String)
      .optionallyWith(
        offset.map(value => Offset.unwrap(value): java.lang.String)
      )(_.offset)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.TumblingWindow.ReadOnly =
    zio.aws.iotsitewise.model.TumblingWindow.wrap(buildAwsValue())
}
object TumblingWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.TumblingWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.TumblingWindow =
      zio.aws.iotsitewise.model
        .TumblingWindow(interval, offset.map(value => value))
    def interval: Interval
    def offset: Option[Offset]
    def getInterval: ZIO[Any, Nothing, Interval] = ZIO.succeed(interval)
    def getOffset: ZIO[Any, AwsError, Offset] =
      AwsError.unwrapOptionField("offset", offset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.TumblingWindow
  ) extends zio.aws.iotsitewise.model.TumblingWindow.ReadOnly {
    override val interval: Interval =
      zio.aws.iotsitewise.model.primitives.Interval(impl.interval())
    override val offset: Option[Offset] = scala
      .Option(impl.offset())
      .map(value => zio.aws.iotsitewise.model.primitives.Offset(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.TumblingWindow
  ): zio.aws.iotsitewise.model.TumblingWindow.ReadOnly = new Wrapper(impl)
}
