package zio.aws.iotsitewise.model
import scala.jdk.CollectionConverters._
sealed trait TraversalDirection {
  def unwrap
      : software.amazon.awssdk.services.iotsitewise.model.TraversalDirection
}
object TraversalDirection {
  def wrap(
      value: software.amazon.awssdk.services.iotsitewise.model.TraversalDirection
  ): zio.aws.iotsitewise.model.TraversalDirection = value match {
    case software.amazon.awssdk.services.iotsitewise.model.TraversalDirection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsitewise.model.TraversalDirection.PARENT =>
      val r = PARENT
      r
    case software.amazon.awssdk.services.iotsitewise.model.TraversalDirection.CHILD =>
      val r = CHILD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsitewise.model.TraversalDirection {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TraversalDirection =
      software.amazon.awssdk.services.iotsitewise.model.TraversalDirection.UNKNOWN_TO_SDK_VERSION
  }
  case object PARENT extends zio.aws.iotsitewise.model.TraversalDirection {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TraversalDirection =
      software.amazon.awssdk.services.iotsitewise.model.TraversalDirection.PARENT
  }
  case object CHILD extends zio.aws.iotsitewise.model.TraversalDirection {
    override def unwrap
        : software.amazon.awssdk.services.iotsitewise.model.TraversalDirection =
      software.amazon.awssdk.services.iotsitewise.model.TraversalDirection.CHILD
  }
}
