package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListGatewaysResponse(
    gatewaySummaries: Iterable[zio.aws.iotsitewise.model.GatewaySummary],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse = {
    import ListGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse
      .builder()
      .gatewaySummaries(gatewaySummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly =
    zio.aws.iotsitewise.model.ListGatewaysResponse.wrap(buildAwsValue())
}
object ListGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListGatewaysResponse =
      zio.aws.iotsitewise.model.ListGatewaysResponse(
        gatewaySummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def gatewaySummaries
        : List[zio.aws.iotsitewise.model.GatewaySummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getGatewaySummaries: ZIO[Any, Nothing, List[
      zio.aws.iotsitewise.model.GatewaySummary.ReadOnly
    ]] = ZIO.succeed(gatewaySummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse
  ) extends zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly {
    override val gatewaySummaries
        : List[zio.aws.iotsitewise.model.GatewaySummary.ReadOnly] = impl
      .gatewaySummaries()
      .asScala
      .map { item =>
        zio.aws.iotsitewise.model.GatewaySummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListGatewaysResponse
  ): zio.aws.iotsitewise.model.ListGatewaysResponse.ReadOnly = new Wrapper(impl)
}
