package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssetPropertyValueResponse(
    propertyValue: Option[zio.aws.iotsitewise.model.AssetPropertyValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse = {
    import GetAssetPropertyValueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse
      .builder()
      .optionallyWith(propertyValue.map(value => value.buildAwsValue()))(
        _.propertyValue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly =
    zio.aws.iotsitewise.model.GetAssetPropertyValueResponse
      .wrap(buildAwsValue())
}
object GetAssetPropertyValueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.GetAssetPropertyValueResponse =
      zio.aws.iotsitewise.model.GetAssetPropertyValueResponse(
        propertyValue.map(value => value.asEditable)
      )
    def propertyValue
        : Option[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly]
    def getPropertyValue: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly
    ] = AwsError.unwrapOptionField("propertyValue", propertyValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse
  ) extends zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly {
    override val propertyValue
        : Option[zio.aws.iotsitewise.model.AssetPropertyValue.ReadOnly] = scala
      .Option(impl.propertyValue())
      .map(value => zio.aws.iotsitewise.model.AssetPropertyValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyValueResponse
  ): zio.aws.iotsitewise.model.GetAssetPropertyValueResponse.ReadOnly =
    new Wrapper(impl)
}
