package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  PortalClientId,
  Url,
  Timestamp,
  Email,
  Description,
  Name,
  ARN,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribePortalResponse(
    portalId: ID,
    portalArn: ARN,
    portalName: Name,
    portalDescription: Option[Description] = None,
    portalClientId: PortalClientId,
    portalStartUrl: Url,
    portalContactEmail: Email,
    portalStatus: zio.aws.iotsitewise.model.PortalStatus,
    portalCreationDate: Timestamp,
    portalLastUpdateDate: Timestamp,
    portalLogoImageLocation: Option[zio.aws.iotsitewise.model.ImageLocation] =
      None,
    roleArn: Option[ARN] = None,
    portalAuthMode: Option[zio.aws.iotsitewise.model.AuthMode] = None,
    notificationSenderEmail: Option[Email] = None,
    alarms: Option[zio.aws.iotsitewise.model.Alarms] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse = {
    import DescribePortalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse
      .builder()
      .portalId(ID.unwrap(portalId): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .portalName(Name.unwrap(portalName): java.lang.String)
      .optionallyWith(
        portalDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.portalDescription)
      .portalClientId(PortalClientId.unwrap(portalClientId): java.lang.String)
      .portalStartUrl(Url.unwrap(portalStartUrl): java.lang.String)
      .portalContactEmail(Email.unwrap(portalContactEmail): java.lang.String)
      .portalStatus(portalStatus.buildAwsValue())
      .portalCreationDate(Timestamp.unwrap(portalCreationDate): Instant)
      .portalLastUpdateDate(Timestamp.unwrap(portalLastUpdateDate): Instant)
      .optionallyWith(
        portalLogoImageLocation.map(value => value.buildAwsValue())
      )(_.portalLogoImageLocation)
      .optionallyWith(
        roleArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(portalAuthMode.map(value => value.unwrap))(
        _.portalAuthMode
      )
      .optionallyWith(
        notificationSenderEmail.map(value =>
          Email.unwrap(value): java.lang.String
        )
      )(_.notificationSenderEmail)
      .optionallyWith(alarms.map(value => value.buildAwsValue()))(_.alarms)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly =
    zio.aws.iotsitewise.model.DescribePortalResponse.wrap(buildAwsValue())
}
object DescribePortalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DescribePortalResponse =
      zio.aws.iotsitewise.model.DescribePortalResponse(
        portalId,
        portalArn,
        portalName,
        portalDescription.map(value => value),
        portalClientId,
        portalStartUrl,
        portalContactEmail,
        portalStatus.asEditable,
        portalCreationDate,
        portalLastUpdateDate,
        portalLogoImageLocation.map(value => value.asEditable),
        roleArn.map(value => value),
        portalAuthMode.map(value => value),
        notificationSenderEmail.map(value => value),
        alarms.map(value => value.asEditable)
      )
    def portalId: ID
    def portalArn: ARN
    def portalName: Name
    def portalDescription: Option[Description]
    def portalClientId: PortalClientId
    def portalStartUrl: Url
    def portalContactEmail: Email
    def portalStatus: zio.aws.iotsitewise.model.PortalStatus.ReadOnly
    def portalCreationDate: Timestamp
    def portalLastUpdateDate: Timestamp
    def portalLogoImageLocation
        : Option[zio.aws.iotsitewise.model.ImageLocation.ReadOnly]
    def roleArn: Option[ARN]
    def portalAuthMode: Option[zio.aws.iotsitewise.model.AuthMode]
    def notificationSenderEmail: Option[Email]
    def alarms: Option[zio.aws.iotsitewise.model.Alarms.ReadOnly]
    def getPortalId: ZIO[Any, Nothing, ID] = ZIO.succeed(portalId)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getPortalName: ZIO[Any, Nothing, Name] = ZIO.succeed(portalName)
    def getPortalDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("portalDescription", portalDescription)
    def getPortalClientId: ZIO[Any, Nothing, PortalClientId] =
      ZIO.succeed(portalClientId)
    def getPortalStartUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(portalStartUrl)
    def getPortalContactEmail: ZIO[Any, Nothing, Email] =
      ZIO.succeed(portalContactEmail)
    def getPortalStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PortalStatus.ReadOnly] =
      ZIO.succeed(portalStatus)
    def getPortalCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(portalCreationDate)
    def getPortalLastUpdateDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(portalLastUpdateDate)
    def getPortalLogoImageLocation
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.ImageLocation.ReadOnly] =
      AwsError.unwrapOptionField(
        "portalLogoImageLocation",
        portalLogoImageLocation
      )
    def getRoleArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getPortalAuthMode
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.AuthMode] =
      AwsError.unwrapOptionField("portalAuthMode", portalAuthMode)
    def getNotificationSenderEmail: ZIO[Any, AwsError, Email] = AwsError
      .unwrapOptionField("notificationSenderEmail", notificationSenderEmail)
    def getAlarms
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse
  ) extends zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly {
    override val portalId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.portalId())
    override val portalArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.portalArn())
    override val portalName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.portalName())
    override val portalDescription: Option[Description] = scala
      .Option(impl.portalDescription())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val portalClientId: PortalClientId =
      zio.aws.iotsitewise.model.primitives.PortalClientId(impl.portalClientId())
    override val portalStartUrl: Url =
      zio.aws.iotsitewise.model.primitives.Url(impl.portalStartUrl())
    override val portalContactEmail: Email =
      zio.aws.iotsitewise.model.primitives.Email(impl.portalContactEmail())
    override val portalStatus: zio.aws.iotsitewise.model.PortalStatus.ReadOnly =
      zio.aws.iotsitewise.model.PortalStatus.wrap(impl.portalStatus())
    override val portalCreationDate: Timestamp =
      zio.aws.iotsitewise.model.primitives.Timestamp(impl.portalCreationDate())
    override val portalLastUpdateDate: Timestamp =
      zio.aws.iotsitewise.model.primitives
        .Timestamp(impl.portalLastUpdateDate())
    override val portalLogoImageLocation
        : Option[zio.aws.iotsitewise.model.ImageLocation.ReadOnly] = scala
      .Option(impl.portalLogoImageLocation())
      .map(value => zio.aws.iotsitewise.model.ImageLocation.wrap(value))
    override val roleArn: Option[ARN] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.iotsitewise.model.primitives.ARN(value))
    override val portalAuthMode: Option[zio.aws.iotsitewise.model.AuthMode] =
      scala
        .Option(impl.portalAuthMode())
        .map(value => zio.aws.iotsitewise.model.AuthMode.wrap(value))
    override val notificationSenderEmail: Option[Email] = scala
      .Option(impl.notificationSenderEmail())
      .map(value => zio.aws.iotsitewise.model.primitives.Email(value))
    override val alarms: Option[zio.aws.iotsitewise.model.Alarms.ReadOnly] =
      scala
        .Option(impl.alarms())
        .map(value => zio.aws.iotsitewise.model.Alarms.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse
  ): zio.aws.iotsitewise.model.DescribePortalResponse.ReadOnly = new Wrapper(
    impl
  )
}
