package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID, PropertyAlias}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTimeSeriesRequest(
    alias: Option[PropertyAlias] = None,
    assetId: Option[ID] = None,
    propertyId: Option[ID] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest = {
    import DeleteTimeSeriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest
      .builder()
      .optionallyWith(
        alias.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(assetId.map(value => ID.unwrap(value): java.lang.String))(
        _.assetId
      )
      .optionallyWith(
        propertyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.propertyId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeleteTimeSeriesRequest.ReadOnly =
    zio.aws.iotsitewise.model.DeleteTimeSeriesRequest.wrap(buildAwsValue())
}
object DeleteTimeSeriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeleteTimeSeriesRequest =
      zio.aws.iotsitewise.model.DeleteTimeSeriesRequest(
        alias.map(value => value),
        assetId.map(value => value),
        propertyId.map(value => value),
        clientToken.map(value => value)
      )
    def alias: Option[PropertyAlias]
    def assetId: Option[ID]
    def propertyId: Option[ID]
    def clientToken: Option[ClientToken]
    def getAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getAssetId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("assetId", assetId)
    def getPropertyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("propertyId", propertyId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest
  ) extends zio.aws.iotsitewise.model.DeleteTimeSeriesRequest.ReadOnly {
    override val alias: Option[PropertyAlias] = scala
      .Option(impl.alias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val assetId: Option[ID] = scala
      .Option(impl.assetId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val propertyId: Option[ID] = scala
      .Option(impl.propertyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteTimeSeriesRequest
  ): zio.aws.iotsitewise.model.DeleteTimeSeriesRequest.ReadOnly = new Wrapper(
    impl
  )
}
