package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAssetResponse(
    assetStatus: zio.aws.iotsitewise.model.AssetStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse = {
    import DeleteAssetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse
      .builder()
      .assetStatus(assetStatus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly =
    zio.aws.iotsitewise.model.DeleteAssetResponse.wrap(buildAwsValue())
}
object DeleteAssetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeleteAssetResponse =
      zio.aws.iotsitewise.model.DeleteAssetResponse(assetStatus.asEditable)
    def assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly
    def getAssetStatus
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.AssetStatus.ReadOnly] =
      ZIO.succeed(assetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse
  ) extends zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly {
    override val assetStatus: zio.aws.iotsitewise.model.AssetStatus.ReadOnly =
      zio.aws.iotsitewise.model.AssetStatus.wrap(impl.assetStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAssetResponse
  ): zio.aws.iotsitewise.model.DeleteAssetResponse.ReadOnly = new Wrapper(impl)
}
