package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{Timestamp, Description, Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DashboardSummary(
    id: ID,
    name: Name,
    description: Option[Description] = None,
    creationDate: Option[Timestamp] = None,
    lastUpdateDate: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DashboardSummary = {
    import DashboardSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DashboardSummary
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastUpdateDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateDate)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DashboardSummary.ReadOnly =
    zio.aws.iotsitewise.model.DashboardSummary.wrap(buildAwsValue())
}
object DashboardSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DashboardSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DashboardSummary =
      zio.aws.iotsitewise.model.DashboardSummary(
        id,
        name,
        description.map(value => value),
        creationDate.map(value => value),
        lastUpdateDate.map(value => value)
      )
    def id: ID
    def name: Name
    def description: Option[Description]
    def creationDate: Option[Timestamp]
    def lastUpdateDate: Option[Timestamp]
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastUpdateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateDate", lastUpdateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DashboardSummary
  ) extends zio.aws.iotsitewise.model.DashboardSummary.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
    override val lastUpdateDate: Option[Timestamp] = scala
      .Option(impl.lastUpdateDate())
      .map(value => zio.aws.iotsitewise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DashboardSummary
  ): zio.aws.iotsitewise.model.DashboardSummary.ReadOnly = new Wrapper(impl)
}
