package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  TagValue,
  DashboardDefinition,
  Description,
  ClientToken,
  Name,
  ID,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDashboardRequest(
    projectId: ID,
    dashboardName: Name,
    dashboardDescription: Option[Description] = None,
    dashboardDefinition: DashboardDefinition,
    clientToken: Option[ClientToken] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest = {
    import CreateDashboardRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest
      .builder()
      .projectId(ID.unwrap(projectId): java.lang.String)
      .dashboardName(Name.unwrap(dashboardName): java.lang.String)
      .optionallyWith(
        dashboardDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.dashboardDescription)
      .dashboardDefinition(
        DashboardDefinition.unwrap(dashboardDefinition): java.lang.String
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.CreateDashboardRequest.ReadOnly =
    zio.aws.iotsitewise.model.CreateDashboardRequest.wrap(buildAwsValue())
}
object CreateDashboardRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.CreateDashboardRequest =
      zio.aws.iotsitewise.model.CreateDashboardRequest(
        projectId,
        dashboardName,
        dashboardDescription.map(value => value),
        dashboardDefinition,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def projectId: ID
    def dashboardName: Name
    def dashboardDescription: Option[Description]
    def dashboardDefinition: DashboardDefinition
    def clientToken: Option[ClientToken]
    def tags: Option[Map[TagKey, TagValue]]
    def getProjectId: ZIO[Any, Nothing, ID] = ZIO.succeed(projectId)
    def getDashboardName: ZIO[Any, Nothing, Name] = ZIO.succeed(dashboardName)
    def getDashboardDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("dashboardDescription", dashboardDescription)
    def getDashboardDefinition: ZIO[Any, Nothing, DashboardDefinition] =
      ZIO.succeed(dashboardDefinition)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest
  ) extends zio.aws.iotsitewise.model.CreateDashboardRequest.ReadOnly {
    override val projectId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.projectId())
    override val dashboardName: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.dashboardName())
    override val dashboardDescription: Option[Description] = scala
      .Option(impl.dashboardDescription())
      .map(value => zio.aws.iotsitewise.model.primitives.Description(value))
    override val dashboardDefinition: DashboardDefinition =
      zio.aws.iotsitewise.model.primitives
        .DashboardDefinition(impl.dashboardDefinition())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iotsitewise.model.primitives.TagKey(
              key
            ) -> zio.aws.iotsitewise.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.CreateDashboardRequest
  ): zio.aws.iotsitewise.model.CreateDashboardRequest.ReadOnly = new Wrapper(
    impl
  )
}
