package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{PropertyUnit, Name, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssetModelProperty(
    id: Option[ID] = None,
    name: Name,
    dataType: zio.aws.iotsitewise.model.PropertyDataType,
    dataTypeSpec: Option[Name] = None,
    unit: Option[PropertyUnit] = None,
    `type`: zio.aws.iotsitewise.model.PropertyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty = {
    import AssetModelProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .name(Name.unwrap(name): java.lang.String)
      .dataType(dataType.unwrap)
      .optionallyWith(
        dataTypeSpec.map(value => Name.unwrap(value): java.lang.String)
      )(_.dataTypeSpec)
      .optionallyWith(
        unit.map(value => PropertyUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .`type`(`type`.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly =
    zio.aws.iotsitewise.model.AssetModelProperty.wrap(buildAwsValue())
}
object AssetModelProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.AssetModelProperty =
      zio.aws.iotsitewise.model.AssetModelProperty(
        id.map(value => value),
        name,
        dataType,
        dataTypeSpec.map(value => value),
        unit.map(value => value),
        `type`.asEditable
      )
    def id: Option[ID]
    def name: Name
    def dataType: zio.aws.iotsitewise.model.PropertyDataType
    def dataTypeSpec: Option[Name]
    def unit: Option[PropertyUnit]
    def `type`: zio.aws.iotsitewise.model.PropertyType.ReadOnly
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyDataType] =
      ZIO.succeed(dataType)
    def getDataTypeSpec: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("dataTypeSpec", dataTypeSpec)
    def getUnit: ZIO[Any, AwsError, PropertyUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyType.ReadOnly] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty
  ) extends zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly {
    override val id: Option[ID] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val dataType: zio.aws.iotsitewise.model.PropertyDataType =
      zio.aws.iotsitewise.model.PropertyDataType.wrap(impl.dataType())
    override val dataTypeSpec: Option[Name] = scala
      .Option(impl.dataTypeSpec())
      .map(value => zio.aws.iotsitewise.model.primitives.Name(value))
    override val unit: Option[PropertyUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyUnit(value))
    override val `type`: zio.aws.iotsitewise.model.PropertyType.ReadOnly =
      zio.aws.iotsitewise.model.PropertyType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty
  ): zio.aws.iotsitewise.model.AssetModelProperty.ReadOnly = new Wrapper(impl)
}
