package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ARN
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Alarms(
    alarmRoleArn: ARN,
    notificationLambdaArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Alarms = {
    import Alarms.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Alarms
      .builder()
      .alarmRoleArn(ARN.unwrap(alarmRoleArn): java.lang.String)
      .optionallyWith(
        notificationLambdaArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.notificationLambdaArn)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Alarms.ReadOnly =
    zio.aws.iotsitewise.model.Alarms.wrap(buildAwsValue())
}
object Alarms {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Alarms
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Alarms = zio.aws.iotsitewise.model
      .Alarms(alarmRoleArn, notificationLambdaArn.map(value => value))
    def alarmRoleArn: ARN
    def notificationLambdaArn: Option[ARN]
    def getAlarmRoleArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(alarmRoleArn)
    def getNotificationLambdaArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("notificationLambdaArn", notificationLambdaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Alarms
  ) extends zio.aws.iotsitewise.model.Alarms.ReadOnly {
    override val alarmRoleArn: ARN =
      zio.aws.iotsitewise.model.primitives.ARN(impl.alarmRoleArn())
    override val notificationLambdaArn: Option[ARN] = scala
      .Option(impl.notificationLambdaArn())
      .map(value => zio.aws.iotsitewise.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Alarms
  ): zio.aws.iotsitewise.model.Alarms.ReadOnly = new Wrapper(impl)
}
