package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.ARN
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutDefaultEncryptionConfigurationResponse(
    encryptionType: zio.aws.iotsitewise.model.EncryptionType,
    kmsKeyArn: Option[ARN] = None,
    configurationStatus: zio.aws.iotsitewise.model.ConfigurationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse = {
    import PutDefaultEncryptionConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse
      .builder()
      .encryptionType(encryptionType.unwrap)
      .optionallyWith(
        kmsKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .configurationStatus(configurationStatus.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly =
    zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse
      .wrap(buildAwsValue())
}
object PutDefaultEncryptionConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse =
      zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse(
        encryptionType,
        kmsKeyArn.map(value => value),
        configurationStatus.asEditable
      )
    def encryptionType: zio.aws.iotsitewise.model.EncryptionType
    def kmsKeyArn: Option[ARN]
    def configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    def getEncryptionType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.EncryptionType] =
      ZIO.succeed(encryptionType)
    def getKmsKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getConfigurationStatus: ZIO[
      Any,
      Nothing,
      zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly
    ] = ZIO.succeed(configurationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse
  ) extends zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly {
    override val encryptionType: zio.aws.iotsitewise.model.EncryptionType =
      zio.aws.iotsitewise.model.EncryptionType.wrap(impl.encryptionType())
    override val kmsKeyArn: Option[ARN] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.iotsitewise.model.primitives.ARN(value))
    override val configurationStatus
        : zio.aws.iotsitewise.model.ConfigurationStatus.ReadOnly =
      zio.aws.iotsitewise.model.ConfigurationStatus
        .wrap(impl.configurationStatus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.PutDefaultEncryptionConfigurationResponse
  ): zio.aws.iotsitewise.model.PutDefaultEncryptionConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
