package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{
  PropertyUnit,
  PropertyAlias,
  Name,
  ID
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Property(
    id: ID,
    name: Name,
    alias: Option[PropertyAlias] = None,
    notification: Option[zio.aws.iotsitewise.model.PropertyNotification] = None,
    dataType: zio.aws.iotsitewise.model.PropertyDataType,
    unit: Option[PropertyUnit] = None,
    `type`: Option[zio.aws.iotsitewise.model.PropertyType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.Property = {
    import Property.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.Property
      .builder()
      .id(ID.unwrap(id): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        alias.map(value => PropertyAlias.unwrap(value): java.lang.String)
      )(_.alias)
      .optionallyWith(notification.map(value => value.buildAwsValue()))(
        _.notification
      )
      .dataType(dataType.unwrap)
      .optionallyWith(
        unit.map(value => PropertyUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .optionallyWith(`type`.map(value => value.buildAwsValue()))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.Property.ReadOnly =
    zio.aws.iotsitewise.model.Property.wrap(buildAwsValue())
}
object Property {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.Property
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.Property =
      zio.aws.iotsitewise.model.Property(
        id,
        name,
        alias.map(value => value),
        notification.map(value => value.asEditable),
        dataType,
        unit.map(value => value),
        `type`.map(value => value.asEditable)
      )
    def id: ID
    def name: Name
    def alias: Option[PropertyAlias]
    def notification
        : Option[zio.aws.iotsitewise.model.PropertyNotification.ReadOnly]
    def dataType: zio.aws.iotsitewise.model.PropertyDataType
    def unit: Option[PropertyUnit]
    def `type`: Option[zio.aws.iotsitewise.model.PropertyType.ReadOnly]
    def getId: ZIO[Any, Nothing, ID] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getAlias: ZIO[Any, AwsError, PropertyAlias] =
      AwsError.unwrapOptionField("alias", alias)
    def getNotification: ZIO[
      Any,
      AwsError,
      zio.aws.iotsitewise.model.PropertyNotification.ReadOnly
    ] = AwsError.unwrapOptionField("notification", notification)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iotsitewise.model.PropertyDataType] =
      ZIO.succeed(dataType)
    def getUnit: ZIO[Any, AwsError, PropertyUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getType
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.PropertyType.ReadOnly] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.Property
  ) extends zio.aws.iotsitewise.model.Property.ReadOnly {
    override val id: ID = zio.aws.iotsitewise.model.primitives.ID(impl.id())
    override val name: Name =
      zio.aws.iotsitewise.model.primitives.Name(impl.name())
    override val alias: Option[PropertyAlias] = scala
      .Option(impl.alias())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyAlias(value))
    override val notification
        : Option[zio.aws.iotsitewise.model.PropertyNotification.ReadOnly] =
      scala
        .Option(impl.notification())
        .map(value =>
          zio.aws.iotsitewise.model.PropertyNotification.wrap(value)
        )
    override val dataType: zio.aws.iotsitewise.model.PropertyDataType =
      zio.aws.iotsitewise.model.PropertyDataType.wrap(impl.dataType())
    override val unit: Option[PropertyUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.iotsitewise.model.primitives.PropertyUnit(value))
    override val `type`
        : Option[zio.aws.iotsitewise.model.PropertyType.ReadOnly] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.iotsitewise.model.PropertyType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.Property
  ): zio.aws.iotsitewise.model.Property.ReadOnly = new Wrapper(impl)
}
