package zio.aws.iotsitewise.model
import java.lang.Integer
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{MaxResults, NextToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssociatedAssetsRequest(
    assetId: ID,
    hierarchyId: Option[ID] = None,
    traversalDirection: Option[zio.aws.iotsitewise.model.TraversalDirection] =
      None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest = {
    import ListAssociatedAssetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .optionallyWith(
        hierarchyId.map(value => ID.unwrap(value): java.lang.String)
      )(_.hierarchyId)
      .optionallyWith(traversalDirection.map(value => value.unwrap))(
        _.traversalDirection
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.ReadOnly =
    zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.wrap(buildAwsValue())
}
object ListAssociatedAssetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.ListAssociatedAssetsRequest =
      zio.aws.iotsitewise.model.ListAssociatedAssetsRequest(
        assetId,
        hierarchyId.map(value => value),
        traversalDirection.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assetId: ID
    def hierarchyId: Option[ID]
    def traversalDirection: Option[zio.aws.iotsitewise.model.TraversalDirection]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getHierarchyId: ZIO[Any, AwsError, ID] =
      AwsError.unwrapOptionField("hierarchyId", hierarchyId)
    def getTraversalDirection
        : ZIO[Any, AwsError, zio.aws.iotsitewise.model.TraversalDirection] =
      AwsError.unwrapOptionField("traversalDirection", traversalDirection)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
  ) extends zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val hierarchyId: Option[ID] = scala
      .Option(impl.hierarchyId())
      .map(value => zio.aws.iotsitewise.model.primitives.ID(value))
    override val traversalDirection
        : Option[zio.aws.iotsitewise.model.TraversalDirection] = scala
      .Option(impl.traversalDirection())
      .map(value => zio.aws.iotsitewise.model.TraversalDirection.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotsitewise.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotsitewise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest
  ): zio.aws.iotsitewise.model.ListAssociatedAssetsRequest.ReadOnly =
    new Wrapper(impl)
}
