package zio.aws.iotsitewise.model
import zio.ZIO
import zio.aws.iotsitewise.model.primitives.{ClientToken, ID}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteAssetRequest(
    assetId: ID,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest = {
    import DeleteAssetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest
      .builder()
      .assetId(ID.unwrap(assetId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsitewise.model.DeleteAssetRequest.ReadOnly =
    zio.aws.iotsitewise.model.DeleteAssetRequest.wrap(buildAwsValue())
}
object DeleteAssetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsitewise.model.DeleteAssetRequest =
      zio.aws.iotsitewise.model
        .DeleteAssetRequest(assetId, clientToken.map(value => value))
    def assetId: ID
    def clientToken: Option[ClientToken]
    def getAssetId: ZIO[Any, Nothing, ID] = ZIO.succeed(assetId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest
  ) extends zio.aws.iotsitewise.model.DeleteAssetRequest.ReadOnly {
    override val assetId: ID =
      zio.aws.iotsitewise.model.primitives.ID(impl.assetId())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.iotsitewise.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsitewise.model.DeleteAssetRequest
  ): zio.aws.iotsitewise.model.DeleteAssetRequest.ReadOnly = new Wrapper(impl)
}
