package zio.aws.iotsecuretunneling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotsecuretunneling.model.primitives.{
  NextToken,
  MaxResults,
  ThingName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTunnelsRequest(
    thingName: Optional[ThingName] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest = {
    import ListTunnelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
      .builder()
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.ListTunnelsRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.ListTunnelsRequest.wrap(buildAwsValue())
}
object ListTunnelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.ListTunnelsRequest =
      zio.aws.iotsecuretunneling.model.ListTunnelsRequest(
        thingName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def thingName: Optional[ThingName]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
  ) extends zio.aws.iotsecuretunneling.model.ListTunnelsRequest.ReadOnly {
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.ThingName(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
  ): zio.aws.iotsecuretunneling.model.ListTunnelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
