package zio.aws.iotsecuretunneling.model
import scala.jdk.CollectionConverters.*
sealed trait TunnelStatus {
  def unwrap
      : software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus
}
object TunnelStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus
  ): zio.aws.iotsecuretunneling.model.TunnelStatus = value match {
    case software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus.CLOSED =>
      val r = CLOSED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsecuretunneling.model.TunnelStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus =
      software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN extends zio.aws.iotsecuretunneling.model.TunnelStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus =
      software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus.OPEN
  }
  case object CLOSED extends zio.aws.iotsecuretunneling.model.TunnelStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus =
      software.amazon.awssdk.services.iotsecuretunneling.model.TunnelStatus.CLOSED
  }
}
