package zio.aws.iotsecuretunneling.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTunnelResponse(
    tunnel: Optional[zio.aws.iotsecuretunneling.model.Tunnel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse = {
    import DescribeTunnelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
      .builder()
      .optionallyWith(tunnel.map(value => value.buildAwsValue()))(_.tunnel)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly =
    zio.aws.iotsecuretunneling.model.DescribeTunnelResponse
      .wrap(buildAwsValue())
}
object DescribeTunnelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.DescribeTunnelResponse =
      zio.aws.iotsecuretunneling.model
        .DescribeTunnelResponse(tunnel.map(value => value.asEditable))
    def tunnel: Optional[zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly]
    def getTunnel
        : ZIO[Any, AwsError, zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly] =
      AwsError.unwrapOptionField("tunnel", tunnel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
  ) extends zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly {
    override val tunnel
        : Optional[zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tunnel())
        .map(value => zio.aws.iotsecuretunneling.model.Tunnel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
  ): zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly =
    new Wrapper(impl)
}
