package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.{
  ClientAccessToken,
  TunnelArn,
  TunnelId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OpenTunnelResponse(
    tunnelId: Optional[TunnelId] = Optional.Absent,
    tunnelArn: Optional[TunnelArn] = Optional.Absent,
    sourceAccessToken: Optional[ClientAccessToken] = Optional.Absent,
    destinationAccessToken: Optional[ClientAccessToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse = {
    import OpenTunnelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
      .builder()
      .optionallyWith(
        tunnelId.map(value => TunnelId.unwrap(value): java.lang.String)
      )(_.tunnelId)
      .optionallyWith(
        tunnelArn.map(value => TunnelArn.unwrap(value): java.lang.String)
      )(_.tunnelArn)
      .optionallyWith(
        sourceAccessToken.map(value =>
          ClientAccessToken.unwrap(value): java.lang.String
        )
      )(_.sourceAccessToken)
      .optionallyWith(
        destinationAccessToken.map(value =>
          ClientAccessToken.unwrap(value): java.lang.String
        )
      )(_.destinationAccessToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly =
    zio.aws.iotsecuretunneling.model.OpenTunnelResponse.wrap(buildAwsValue())
}
object OpenTunnelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.OpenTunnelResponse =
      zio.aws.iotsecuretunneling.model.OpenTunnelResponse(
        tunnelId.map(value => value),
        tunnelArn.map(value => value),
        sourceAccessToken.map(value => value),
        destinationAccessToken.map(value => value)
      )
    def tunnelId: Optional[TunnelId]
    def tunnelArn: Optional[TunnelArn]
    def sourceAccessToken: Optional[ClientAccessToken]
    def destinationAccessToken: Optional[ClientAccessToken]
    def getTunnelId: ZIO[Any, AwsError, TunnelId] =
      AwsError.unwrapOptionField("tunnelId", tunnelId)
    def getTunnelArn: ZIO[Any, AwsError, TunnelArn] =
      AwsError.unwrapOptionField("tunnelArn", tunnelArn)
    def getSourceAccessToken: ZIO[Any, AwsError, ClientAccessToken] =
      AwsError.unwrapOptionField("sourceAccessToken", sourceAccessToken)
    def getDestinationAccessToken: ZIO[Any, AwsError, ClientAccessToken] =
      AwsError.unwrapOptionField(
        "destinationAccessToken",
        destinationAccessToken
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
  ) extends zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly {
    override val tunnelId: Optional[TunnelId] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelId())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.TunnelId(value))
    override val tunnelArn: Optional[TunnelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelArn())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TunnelArn(value)
      )
    override val sourceAccessToken: Optional[ClientAccessToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceAccessToken())
        .map(value =>
          zio.aws.iotsecuretunneling.model.primitives.ClientAccessToken(value)
        )
    override val destinationAccessToken: Optional[ClientAccessToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationAccessToken())
        .map(value =>
          zio.aws.iotsecuretunneling.model.primitives.ClientAccessToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
  ): zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly = new Wrapper(
    impl
  )
}
