package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.TunnelId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTunnelRequest(tunnelId: TunnelId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelRequest = {
    import DescribeTunnelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelRequest
      .builder()
      .tunnelId(TunnelId.unwrap(tunnelId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsecuretunneling.model.DescribeTunnelRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.DescribeTunnelRequest.wrap(buildAwsValue())
}
object DescribeTunnelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.DescribeTunnelRequest =
      zio.aws.iotsecuretunneling.model.DescribeTunnelRequest(tunnelId)
    def tunnelId: TunnelId
    def getTunnelId: ZIO[Any, Nothing, TunnelId] = ZIO.succeed(tunnelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelRequest
  ) extends zio.aws.iotsecuretunneling.model.DescribeTunnelRequest.ReadOnly {
    override val tunnelId: TunnelId =
      zio.aws.iotsecuretunneling.model.primitives.TunnelId(impl.tunnelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelRequest
  ): zio.aws.iotsecuretunneling.model.DescribeTunnelRequest.ReadOnly =
    new Wrapper(impl)
}
