package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OpenTunnelRequest(
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotsecuretunneling.model.Tag]] =
      Optional.Absent,
    destinationConfig: Optional[
      zio.aws.iotsecuretunneling.model.DestinationConfig
    ] = Optional.Absent,
    timeoutConfig: Optional[zio.aws.iotsecuretunneling.model.TimeoutConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest = {
    import OpenTunnelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.OpenTunnelRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.OpenTunnelRequest.wrap(buildAwsValue())
}
object OpenTunnelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.OpenTunnelRequest =
      zio.aws.iotsecuretunneling.model.OpenTunnelRequest(
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable)
      )
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]]
    def destinationConfig
        : Optional[zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly]
    def timeoutConfig
        : Optional[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.iotsecuretunneling.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getDestinationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getTimeoutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly
    ] = AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
  ) extends zio.aws.iotsecuretunneling.model.OpenTunnelRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.Description(value)
      )
    override val tags
        : Optional[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsecuretunneling.model.Tag.wrap(item)
          }.toList
        )
    override val destinationConfig: Optional[
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationConfig())
      .map(value =>
        zio.aws.iotsecuretunneling.model.DestinationConfig.wrap(value)
      )
    override val timeoutConfig
        : Optional[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutConfig())
        .map(value =>
          zio.aws.iotsecuretunneling.model.TimeoutConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
  ): zio.aws.iotsecuretunneling.model.OpenTunnelRequest.ReadOnly = new Wrapper(
    impl
  )
}
