package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.{
  ClientAccessToken,
  TunnelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RotateTunnelAccessTokenResponse(
    tunnelArn: Optional[TunnelArn] = Optional.Absent,
    sourceAccessToken: Optional[ClientAccessToken] = Optional.Absent,
    destinationAccessToken: Optional[ClientAccessToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenResponse = {
    import RotateTunnelAccessTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenResponse
      .builder()
      .optionallyWith(
        tunnelArn.map(value => TunnelArn.unwrap(value): java.lang.String)
      )(_.tunnelArn)
      .optionallyWith(
        sourceAccessToken.map(value =>
          ClientAccessToken.unwrap(value): java.lang.String
        )
      )(_.sourceAccessToken)
      .optionallyWith(
        destinationAccessToken.map(value =>
          ClientAccessToken.unwrap(value): java.lang.String
        )
      )(_.destinationAccessToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenResponse.ReadOnly =
    zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenResponse
      .wrap(buildAwsValue())
}
object RotateTunnelAccessTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenResponse =
      zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenResponse(
        tunnelArn.map(value => value),
        sourceAccessToken.map(value => value),
        destinationAccessToken.map(value => value)
      )
    def tunnelArn: Optional[TunnelArn]
    def sourceAccessToken: Optional[ClientAccessToken]
    def destinationAccessToken: Optional[ClientAccessToken]
    def getTunnelArn: ZIO[Any, AwsError, TunnelArn] =
      AwsError.unwrapOptionField("tunnelArn", tunnelArn)
    def getSourceAccessToken: ZIO[Any, AwsError, ClientAccessToken] =
      AwsError.unwrapOptionField("sourceAccessToken", sourceAccessToken)
    def getDestinationAccessToken: ZIO[Any, AwsError, ClientAccessToken] =
      AwsError.unwrapOptionField(
        "destinationAccessToken",
        destinationAccessToken
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenResponse
  ) extends zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenResponse.ReadOnly {
    override val tunnelArn: Optional[TunnelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelArn())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TunnelArn(value)
      )
    override val sourceAccessToken: Optional[ClientAccessToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceAccessToken())
        .map(value =>
          zio.aws.iotsecuretunneling.model.primitives.ClientAccessToken(value)
        )
    override val destinationAccessToken: Optional[ClientAccessToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationAccessToken())
        .map(value =>
          zio.aws.iotsecuretunneling.model.primitives.ClientAccessToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenResponse
  ): zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenResponse.ReadOnly =
    new Wrapper(impl)
}
