package zio.aws.iotsecuretunneling.model
import scala.jdk.CollectionConverters.*
sealed trait ClientMode {
  def unwrap
      : software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode
}
object ClientMode {
  def wrap(
      value: software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode
  ): zio.aws.iotsecuretunneling.model.ClientMode = value match {
    case software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.SOURCE =>
      val r = SOURCE
      r
    case software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.DESTINATION =>
      val r = DESTINATION
      r
    case software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsecuretunneling.model.ClientMode {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode =
      software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SOURCE extends zio.aws.iotsecuretunneling.model.ClientMode {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode =
      software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.SOURCE
  }
  case object DESTINATION extends zio.aws.iotsecuretunneling.model.ClientMode {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode =
      software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.DESTINATION
  }
  case object ALL extends zio.aws.iotsecuretunneling.model.ClientMode {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode =
      software.amazon.awssdk.services.iotsecuretunneling.model.ClientMode.ALL
  }
}
