package zio.aws.iotsecuretunneling.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotsecuretunneling.model.primitives.TimeoutInMin
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TimeoutConfig(
    maxLifetimeTimeoutMinutes: Optional[TimeoutInMin] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig = {
    import TimeoutConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
      .builder()
      .optionallyWith(
        maxLifetimeTimeoutMinutes.map(value =>
          TimeoutInMin.unwrap(value): Integer
        )
      )(_.maxLifetimeTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly =
    zio.aws.iotsecuretunneling.model.TimeoutConfig.wrap(buildAwsValue())
}
object TimeoutConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.TimeoutConfig =
      zio.aws.iotsecuretunneling.model
        .TimeoutConfig(maxLifetimeTimeoutMinutes.map(value => value))
    def maxLifetimeTimeoutMinutes: Optional[TimeoutInMin]
    def getMaxLifetimeTimeoutMinutes: ZIO[Any, AwsError, TimeoutInMin] =
      AwsError.unwrapOptionField(
        "maxLifetimeTimeoutMinutes",
        maxLifetimeTimeoutMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
  ) extends zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly {
    override val maxLifetimeTimeoutMinutes: Optional[TimeoutInMin] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxLifetimeTimeoutMinutes())
        .map(value =>
          zio.aws.iotsecuretunneling.model.primitives.TimeoutInMin(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
  ): zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly = new Wrapper(impl)
}
