package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.Description
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OpenTunnelRequest(
    description: Option[Description] = None,
    tags: Option[Iterable[zio.aws.iotsecuretunneling.model.Tag]] = None,
    destinationConfig: Option[
      zio.aws.iotsecuretunneling.model.DestinationConfig
    ] = None,
    timeoutConfig: Option[zio.aws.iotsecuretunneling.model.TimeoutConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest = {
    import OpenTunnelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.OpenTunnelRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.OpenTunnelRequest.wrap(buildAwsValue())
}
object OpenTunnelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.OpenTunnelRequest =
      zio.aws.iotsecuretunneling.model.OpenTunnelRequest(
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable)
      )
    def description: Option[Description]
    def tags: Option[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]]
    def destinationConfig
        : Option[zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly]
    def timeoutConfig
        : Option[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.iotsecuretunneling.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getDestinationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getTimeoutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly
    ] = AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
  ) extends zio.aws.iotsecuretunneling.model.OpenTunnelRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.Description(value)
      )
    override val tags
        : Option[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsecuretunneling.model.Tag.wrap(item)
        }.toList
      )
    override val destinationConfig
        : Option[zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly] =
      scala
        .Option(impl.destinationConfig())
        .map(value =>
          zio.aws.iotsecuretunneling.model.DestinationConfig.wrap(value)
        )
    override val timeoutConfig
        : Option[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly] =
      scala
        .Option(impl.timeoutConfig())
        .map(value =>
          zio.aws.iotsecuretunneling.model.TimeoutConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelRequest
  ): zio.aws.iotsecuretunneling.model.OpenTunnelRequest.ReadOnly = new Wrapper(
    impl
  )
}
