package zio.aws.iotsecuretunneling
import zio.aws.iotsecuretunneling.model.CloseTunnelResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.iotsecuretunneling.model.{
  ListTunnelsRequest,
  ListTagsForResourceRequest,
  DescribeTunnelRequest,
  UntagResourceRequest,
  CloseTunnelRequest,
  TagResourceRequest,
  OpenTunnelRequest
}
import software.amazon.awssdk.services.iotsecuretunneling.IoTSecureTunnelingAsyncClient
object IoTSecureTunnelingMock extends Mock[IoTSecureTunneling] {
  object DescribeTunnel
      extends Effect[
        DescribeTunnelRequest,
        AwsError,
        zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotsecuretunneling.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotsecuretunneling.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iotsecuretunneling.model.TagResourceResponse.ReadOnly
      ]
  object OpenTunnel
      extends Effect[
        OpenTunnelRequest,
        AwsError,
        zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly
      ]
  object CloseTunnel extends Effect[CloseTunnelRequest, AwsError, ReadOnly]
  object ListTunnels
      extends Effect[
        ListTunnelsRequest,
        AwsError,
        zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IoTSecureTunneling] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new IoTSecureTunneling {
          val api: IoTSecureTunnelingAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : IoTSecureTunneling = this
          def describeTunnel(request: DescribeTunnelRequest): IO[
            AwsError,
            zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly
          ] = proxy(DescribeTunnel, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.iotsecuretunneling.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.iotsecuretunneling.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.iotsecuretunneling.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def openTunnel(request: OpenTunnelRequest): IO[
            AwsError,
            zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly
          ] = proxy(OpenTunnel, request)
          def closeTunnel(request: CloseTunnelRequest): IO[AwsError, ReadOnly] =
            proxy(CloseTunnel, request)
          def listTunnels(request: ListTunnelsRequest): IO[
            AwsError,
            zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly
          ] = proxy(ListTunnels, request)
        }
      }
    }
    .toLayer
}
