package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest =
      zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AmazonResourceName
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceRequest
  ) extends zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.iotsecuretunneling.model.primitives
        .AmazonResourceName(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTagsForResourceRequest
  ): zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
