package zio.aws.iotsecuretunneling.model
import java.lang.Integer
import zio.aws.iotsecuretunneling.model.primitives.TimeoutInMin
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TimeoutConfig(
    maxLifetimeTimeoutMinutes: Option[TimeoutInMin] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig = {
    import TimeoutConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
      .builder()
      .optionallyWith(
        maxLifetimeTimeoutMinutes.map(value =>
          TimeoutInMin.unwrap(value): Integer
        )
      )(_.maxLifetimeTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly =
    zio.aws.iotsecuretunneling.model.TimeoutConfig.wrap(buildAwsValue())
}
object TimeoutConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.TimeoutConfig =
      zio.aws.iotsecuretunneling.model
        .TimeoutConfig(maxLifetimeTimeoutMinutes.map(value => value))
    def maxLifetimeTimeoutMinutes: Option[TimeoutInMin]
    def getMaxLifetimeTimeoutMinutes: ZIO[Any, AwsError, TimeoutInMin] =
      AwsError.unwrapOptionField(
        "maxLifetimeTimeoutMinutes",
        maxLifetimeTimeoutMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
  ) extends zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly {
    override val maxLifetimeTimeoutMinutes: Option[TimeoutInMin] = scala
      .Option(impl.maxLifetimeTimeoutMinutes())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TimeoutInMin(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig
  ): zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly = new Wrapper(impl)
}
