package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.{Service, ThingName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DestinationConfig(
    thingName: Optional[ThingName] = Optional.Absent,
    services: Iterable[Service]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig = {
    import DestinationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig
      .builder()
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .services(services.map { item =>
        Service.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly =
    zio.aws.iotsecuretunneling.model.DestinationConfig.wrap(buildAwsValue())
}
object DestinationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.DestinationConfig =
      zio.aws.iotsecuretunneling.model
        .DestinationConfig(thingName.map(value => value), services)
    def thingName: Optional[ThingName]
    def services: List[Service]
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getServices: ZIO[Any, Nothing, List[Service]] = ZIO.succeed(services)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig
  ) extends zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly {
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.ThingName(value)
      )
    override val services: List[Service] = impl
      .services()
      .asScala
      .map { item =>
        zio.aws.iotsecuretunneling.model.primitives.Service(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig
  ): zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly = new Wrapper(
    impl
  )
}
