package zio.aws.iotsecuretunneling.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotsecuretunneling.model.primitives.{
  DateType,
  Description,
  TunnelArn,
  TunnelId
}
import scala.jdk.CollectionConverters._
final case class TunnelSummary(
    tunnelId: Optional[TunnelId] = Optional.Absent,
    tunnelArn: Optional[TunnelArn] = Optional.Absent,
    status: Optional[zio.aws.iotsecuretunneling.model.TunnelStatus] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    createdAt: Optional[DateType] = Optional.Absent,
    lastUpdatedAt: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary = {
    import TunnelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
      .builder()
      .optionallyWith(
        tunnelId.map(value => TunnelId.unwrap(value): java.lang.String)
      )(_.tunnelId)
      .optionallyWith(
        tunnelArn.map(value => TunnelArn.unwrap(value): java.lang.String)
      )(_.tunnelArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly =
    zio.aws.iotsecuretunneling.model.TunnelSummary.wrap(buildAwsValue())
}
object TunnelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.TunnelSummary =
      zio.aws.iotsecuretunneling.model.TunnelSummary(
        tunnelId.map(value => value),
        tunnelArn.map(value => value),
        status.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def tunnelId: Optional[TunnelId]
    def tunnelArn: Optional[TunnelArn]
    def status: Optional[zio.aws.iotsecuretunneling.model.TunnelStatus]
    def description: Optional[Description]
    def createdAt: Optional[DateType]
    def lastUpdatedAt: Optional[DateType]
    def getTunnelId: ZIO[Any, AwsError, TunnelId] =
      AwsError.unwrapOptionField("tunnelId", tunnelId)
    def getTunnelArn: ZIO[Any, AwsError, TunnelArn] =
      AwsError.unwrapOptionField("tunnelArn", tunnelArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotsecuretunneling.model.TunnelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
  ) extends zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly {
    override val tunnelId: Optional[TunnelId] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelId())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.TunnelId(value))
    override val tunnelArn: Optional[TunnelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelArn())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TunnelArn(value)
      )
    override val status
        : Optional[zio.aws.iotsecuretunneling.model.TunnelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotsecuretunneling.model.TunnelStatus.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.Description(value)
      )
    override val createdAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
    override val lastUpdatedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
  ): zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly = new Wrapper(impl)
}
