package zio.aws.iotsecuretunneling.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotsecuretunneling.model.primitives.{
  DateType,
  Description,
  TunnelArn,
  TunnelId
}
import scala.jdk.CollectionConverters._
final case class Tunnel(
    tunnelId: Optional[TunnelId] = Optional.Absent,
    tunnelArn: Optional[TunnelArn] = Optional.Absent,
    status: Optional[zio.aws.iotsecuretunneling.model.TunnelStatus] =
      Optional.Absent,
    sourceConnectionState: Optional[
      zio.aws.iotsecuretunneling.model.ConnectionState
    ] = Optional.Absent,
    destinationConnectionState: Optional[
      zio.aws.iotsecuretunneling.model.ConnectionState
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    destinationConfig: Optional[
      zio.aws.iotsecuretunneling.model.DestinationConfig
    ] = Optional.Absent,
    timeoutConfig: Optional[zio.aws.iotsecuretunneling.model.TimeoutConfig] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotsecuretunneling.model.Tag]] =
      Optional.Absent,
    createdAt: Optional[DateType] = Optional.Absent,
    lastUpdatedAt: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel = {
    import Tunnel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
      .builder()
      .optionallyWith(
        tunnelId.map(value => TunnelId.unwrap(value): java.lang.String)
      )(_.tunnelId)
      .optionallyWith(
        tunnelArn.map(value => TunnelArn.unwrap(value): java.lang.String)
      )(_.tunnelArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sourceConnectionState.map(value => value.buildAwsValue())
      )(_.sourceConnectionState)
      .optionallyWith(
        destinationConnectionState.map(value => value.buildAwsValue())
      )(_.destinationConnectionState)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly =
    zio.aws.iotsecuretunneling.model.Tunnel.wrap(buildAwsValue())
}
object Tunnel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.Tunnel =
      zio.aws.iotsecuretunneling.model.Tunnel(
        tunnelId.map(value => value),
        tunnelArn.map(value => value),
        status.map(value => value),
        sourceConnectionState.map(value => value.asEditable),
        destinationConnectionState.map(value => value.asEditable),
        description.map(value => value),
        destinationConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def tunnelId: Optional[TunnelId]
    def tunnelArn: Optional[TunnelArn]
    def status: Optional[zio.aws.iotsecuretunneling.model.TunnelStatus]
    def sourceConnectionState
        : Optional[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly]
    def destinationConnectionState
        : Optional[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly]
    def description: Optional[Description]
    def destinationConfig
        : Optional[zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly]
    def timeoutConfig
        : Optional[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly]
    def tags: Optional[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]]
    def createdAt: Optional[DateType]
    def lastUpdatedAt: Optional[DateType]
    def getTunnelId: ZIO[Any, AwsError, TunnelId] =
      AwsError.unwrapOptionField("tunnelId", tunnelId)
    def getTunnelArn: ZIO[Any, AwsError, TunnelArn] =
      AwsError.unwrapOptionField("tunnelArn", tunnelArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotsecuretunneling.model.TunnelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSourceConnectionState: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly
    ] =
      AwsError.unwrapOptionField("sourceConnectionState", sourceConnectionState)
    def getDestinationConnectionState: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationConnectionState",
      destinationConnectionState
    )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getTimeoutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly
    ] = AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.iotsecuretunneling.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
  ) extends zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly {
    override val tunnelId: Optional[TunnelId] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelId())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.TunnelId(value))
    override val tunnelArn: Optional[TunnelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelArn())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TunnelArn(value)
      )
    override val status
        : Optional[zio.aws.iotsecuretunneling.model.TunnelStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotsecuretunneling.model.TunnelStatus.wrap(value))
    override val sourceConnectionState
        : Optional[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceConnectionState())
        .map(value =>
          zio.aws.iotsecuretunneling.model.ConnectionState.wrap(value)
        )
    override val destinationConnectionState
        : Optional[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConnectionState())
        .map(value =>
          zio.aws.iotsecuretunneling.model.ConnectionState.wrap(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.Description(value)
      )
    override val destinationConfig: Optional[
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationConfig())
      .map(value =>
        zio.aws.iotsecuretunneling.model.DestinationConfig.wrap(value)
      )
    override val timeoutConfig
        : Optional[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutConfig())
        .map(value =>
          zio.aws.iotsecuretunneling.model.TimeoutConfig.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotsecuretunneling.model.Tag.wrap(item)
          }.toList
        )
    override val createdAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
    override val lastUpdatedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
  ): zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly = new Wrapper(impl)
}
