package zio.aws.iotsecuretunneling.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionStatus {
  def unwrap: software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus
}
object ConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus
  ): zio.aws.iotsecuretunneling.model.ConnectionStatus = value match {
    case software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus.DISCONNECTED =>
      val r = DISCONNECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotsecuretunneling.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus =
      software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED
      extends zio.aws.iotsecuretunneling.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus =
      software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus.CONNECTED
  }
  case object DISCONNECTED
      extends zio.aws.iotsecuretunneling.model.ConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus =
      software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionStatus.DISCONNECTED
  }
}
