package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AmazonResourceName,
    tags: Iterable[zio.aws.iotsecuretunneling.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.TagResourceRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.TagResourceRequest =
      zio.aws.iotsecuretunneling.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AmazonResourceName
    def tags: List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.iotsecuretunneling.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceRequest
  ) extends zio.aws.iotsecuretunneling.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.iotsecuretunneling.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tags: List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.iotsecuretunneling.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TagResourceRequest
  ): zio.aws.iotsecuretunneling.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
