package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.TunnelId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RotateTunnelAccessTokenRequest(
    tunnelId: TunnelId,
    clientMode: zio.aws.iotsecuretunneling.model.ClientMode,
    destinationConfig: Optional[
      zio.aws.iotsecuretunneling.model.DestinationConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenRequest = {
    import RotateTunnelAccessTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenRequest
      .builder()
      .tunnelId(TunnelId.unwrap(tunnelId): java.lang.String)
      .clientMode(clientMode.unwrap)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenRequest
      .wrap(buildAwsValue())
}
object RotateTunnelAccessTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenRequest =
      zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenRequest(
        tunnelId,
        clientMode,
        destinationConfig.map(value => value.asEditable)
      )
    def tunnelId: TunnelId
    def clientMode: zio.aws.iotsecuretunneling.model.ClientMode
    def destinationConfig
        : Optional[zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly]
    def getTunnelId: ZIO[Any, Nothing, TunnelId] = ZIO.succeed(tunnelId)
    def getClientMode
        : ZIO[Any, Nothing, zio.aws.iotsecuretunneling.model.ClientMode] =
      ZIO.succeed(clientMode)
    def getDestinationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("destinationConfig", destinationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenRequest
  ) extends zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenRequest.ReadOnly {
    override val tunnelId: TunnelId =
      zio.aws.iotsecuretunneling.model.primitives.TunnelId(impl.tunnelId())
    override val clientMode: zio.aws.iotsecuretunneling.model.ClientMode =
      zio.aws.iotsecuretunneling.model.ClientMode.wrap(impl.clientMode())
    override val destinationConfig: Optional[
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationConfig())
      .map(value =>
        zio.aws.iotsecuretunneling.model.DestinationConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.RotateTunnelAccessTokenRequest
  ): zio.aws.iotsecuretunneling.model.RotateTunnelAccessTokenRequest.ReadOnly =
    new Wrapper(impl)
}
