package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTunnelsResponse(
    tunnelSummaries: Optional[
      Iterable[zio.aws.iotsecuretunneling.model.TunnelSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse = {
    import ListTunnelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse
      .builder()
      .optionallyWith(
        tunnelSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tunnelSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly =
    zio.aws.iotsecuretunneling.model.ListTunnelsResponse.wrap(buildAwsValue())
}
object ListTunnelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.ListTunnelsResponse =
      zio.aws.iotsecuretunneling.model.ListTunnelsResponse(
        tunnelSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tunnelSummaries: Optional[
      List[zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getTunnelSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("tunnelSummaries", tunnelSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse
  ) extends zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly {
    override val tunnelSummaries: Optional[
      List[zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tunnelSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsecuretunneling.model.TunnelSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse
  ): zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly =
    new Wrapper(impl)
}
