package zio.aws.iotsecuretunneling
import zio.aws.core.config.AwsConfig
import zio.aws.iotsecuretunneling.model.CloseTunnelResponse.ReadOnly
import software.amazon.awssdk.services.iotsecuretunneling.model.{
  ListTunnelsRequest,
  DescribeTunnelResponse,
  ListTagsForResourceRequest,
  ListTagsForResourceResponse,
  DescribeTunnelRequest,
  UntagResourceResponse,
  CloseTunnelResponse,
  OpenTunnelResponse,
  UntagResourceRequest,
  CloseTunnelRequest,
  TagResourceResponse,
  TagResourceRequest,
  ListTunnelsResponse,
  OpenTunnelRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.iotsecuretunneling.{
  IoTSecureTunnelingAsyncClientBuilder,
  IoTSecureTunnelingAsyncClient
}
import scala.jdk.CollectionConverters._
trait IoTSecureTunneling extends AspectSupport[IoTSecureTunneling] {
  val api: IoTSecureTunnelingAsyncClient
  def describeTunnel(
      request: zio.aws.iotsecuretunneling.model.DescribeTunnelRequest
  ): IO[
    AwsError,
    zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.iotsecuretunneling.model.UntagResourceRequest
  ): IO[
    AwsError,
    zio.aws.iotsecuretunneling.model.UntagResourceResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.iotsecuretunneling.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.iotsecuretunneling.model.TagResourceRequest
  ): IO[AwsError, zio.aws.iotsecuretunneling.model.TagResourceResponse.ReadOnly]
  def openTunnel(
      request: zio.aws.iotsecuretunneling.model.OpenTunnelRequest
  ): IO[AwsError, zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly]
  def closeTunnel(
      request: zio.aws.iotsecuretunneling.model.CloseTunnelRequest
  ): IO[AwsError, ReadOnly]
  def listTunnels(
      request: zio.aws.iotsecuretunneling.model.ListTunnelsRequest
  ): IO[AwsError, zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly]
}
object IoTSecureTunneling {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IoTSecureTunneling] =
    customized(identity)
  def customized(
      customization: IoTSecureTunnelingAsyncClientBuilder => IoTSecureTunnelingAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IoTSecureTunneling] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IoTSecureTunnelingAsyncClientBuilder => IoTSecureTunnelingAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IoTSecureTunneling] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IoTSecureTunnelingAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      IoTSecureTunnelingAsyncClient,
      IoTSecureTunnelingAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      IoTSecureTunnelingAsyncClient,
      IoTSecureTunnelingAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IoTSecureTunnelingImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IoTSecureTunnelingImpl[R](
      override val api: IoTSecureTunnelingAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IoTSecureTunneling
      with AwsServiceBase[R] {
    override val serviceName: String = "IoTSecureTunneling"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IoTSecureTunnelingImpl[R1] =
      new IoTSecureTunnelingImpl(api, newAspect, r)
    def describeTunnel(
        request: zio.aws.iotsecuretunneling.model.DescribeTunnelRequest
    ): IO[
      AwsError,
      zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly
    ] = asyncRequestResponse[DescribeTunnelRequest, DescribeTunnelResponse](
      "describeTunnel",
      api.describeTunnel
    )(request.buildAwsValue())
      .map(zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.iotsecuretunneling.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotsecuretunneling.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.iotsecuretunneling.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotsecuretunneling.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotsecuretunneling.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.iotsecuretunneling.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotsecuretunneling.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.iotsecuretunneling.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def openTunnel(
        request: zio.aws.iotsecuretunneling.model.OpenTunnelRequest
    ): IO[
      AwsError,
      zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly
    ] = asyncRequestResponse[OpenTunnelRequest, OpenTunnelResponse](
      "openTunnel",
      api.openTunnel
    )(request.buildAwsValue())
      .map(zio.aws.iotsecuretunneling.model.OpenTunnelResponse.wrap)
      .provideEnvironment(r)
    def closeTunnel(
        request: zio.aws.iotsecuretunneling.model.CloseTunnelRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CloseTunnelRequest, CloseTunnelResponse](
        "closeTunnel",
        api.closeTunnel
      )(request.buildAwsValue())
        .map(zio.aws.iotsecuretunneling.model.CloseTunnelResponse.wrap)
        .provideEnvironment(r)
    def listTunnels(
        request: zio.aws.iotsecuretunneling.model.ListTunnelsRequest
    ): IO[
      AwsError,
      zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly
    ] = asyncRequestResponse[ListTunnelsRequest, ListTunnelsResponse](
      "listTunnels",
      api.listTunnels
    )(request.buildAwsValue())
      .map(zio.aws.iotsecuretunneling.model.ListTunnelsResponse.wrap)
      .provideEnvironment(r)
  }
  def describeTunnel(
      request: zio.aws.iotsecuretunneling.model.DescribeTunnelRequest
  ): ZIO[
    zio.aws.iotsecuretunneling.IoTSecureTunneling,
    AwsError,
    zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTunnel(request))
  def untagResource(
      request: zio.aws.iotsecuretunneling.model.UntagResourceRequest
  ): ZIO[
    zio.aws.iotsecuretunneling.IoTSecureTunneling,
    AwsError,
    zio.aws.iotsecuretunneling.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(
      request: zio.aws.iotsecuretunneling.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.iotsecuretunneling.IoTSecureTunneling,
    AwsError,
    zio.aws.iotsecuretunneling.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.iotsecuretunneling.model.TagResourceRequest
  ): ZIO[
    zio.aws.iotsecuretunneling.IoTSecureTunneling,
    AwsError,
    zio.aws.iotsecuretunneling.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def openTunnel(
      request: zio.aws.iotsecuretunneling.model.OpenTunnelRequest
  ): ZIO[
    zio.aws.iotsecuretunneling.IoTSecureTunneling,
    AwsError,
    zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.openTunnel(request))
  def closeTunnel(
      request: zio.aws.iotsecuretunneling.model.CloseTunnelRequest
  ): ZIO[zio.aws.iotsecuretunneling.IoTSecureTunneling, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.closeTunnel(request))
  def listTunnels(
      request: zio.aws.iotsecuretunneling.model.ListTunnelsRequest
  ): ZIO[
    zio.aws.iotsecuretunneling.IoTSecureTunneling,
    AwsError,
    zio.aws.iotsecuretunneling.model.ListTunnelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTunnels(request))
}
