package zio.aws.iotsecuretunneling.model
import java.lang.Integer
import zio.aws.iotsecuretunneling.model.primitives.{
  NextToken,
  MaxResults,
  ThingName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTunnelsRequest(
    thingName: Option[ThingName] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest = {
    import ListTunnelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
      .builder()
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.ListTunnelsRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.ListTunnelsRequest.wrap(buildAwsValue())
}
object ListTunnelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.ListTunnelsRequest =
      zio.aws.iotsecuretunneling.model.ListTunnelsRequest(
        thingName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def thingName: Option[ThingName]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
  ) extends zio.aws.iotsecuretunneling.model.ListTunnelsRequest.ReadOnly {
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.ThingName(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest
  ): zio.aws.iotsecuretunneling.model.ListTunnelsRequest.ReadOnly = new Wrapper(
    impl
  )
}
