package zio.aws.iotsecuretunneling.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTunnelResponse(
    tunnel: Option[zio.aws.iotsecuretunneling.model.Tunnel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse = {
    import DescribeTunnelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
      .builder()
      .optionallyWith(tunnel.map(value => value.buildAwsValue()))(_.tunnel)
      .build()
  }
  def asReadOnly
      : zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly =
    zio.aws.iotsecuretunneling.model.DescribeTunnelResponse
      .wrap(buildAwsValue())
}
object DescribeTunnelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.DescribeTunnelResponse =
      zio.aws.iotsecuretunneling.model
        .DescribeTunnelResponse(tunnel.map(value => value.asEditable))
    def tunnel: Option[zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly]
    def getTunnel
        : ZIO[Any, AwsError, zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly] =
      AwsError.unwrapOptionField("tunnel", tunnel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
  ) extends zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly {
    override val tunnel
        : Option[zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly] = scala
      .Option(impl.tunnel())
      .map(value => zio.aws.iotsecuretunneling.model.Tunnel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.DescribeTunnelResponse
  ): zio.aws.iotsecuretunneling.model.DescribeTunnelResponse.ReadOnly =
    new Wrapper(impl)
}
