package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.{
  DateType,
  Description,
  TunnelArn,
  TunnelId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TunnelSummary(
    tunnelId: Option[TunnelId] = None,
    tunnelArn: Option[TunnelArn] = None,
    status: Option[zio.aws.iotsecuretunneling.model.TunnelStatus] = None,
    description: Option[Description] = None,
    createdAt: Option[DateType] = None,
    lastUpdatedAt: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary = {
    import TunnelSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
      .builder()
      .optionallyWith(
        tunnelId.map(value => TunnelId.unwrap(value): java.lang.String)
      )(_.tunnelId)
      .optionallyWith(
        tunnelArn.map(value => TunnelArn.unwrap(value): java.lang.String)
      )(_.tunnelArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly =
    zio.aws.iotsecuretunneling.model.TunnelSummary.wrap(buildAwsValue())
}
object TunnelSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.TunnelSummary =
      zio.aws.iotsecuretunneling.model.TunnelSummary(
        tunnelId.map(value => value),
        tunnelArn.map(value => value),
        status.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def tunnelId: Option[TunnelId]
    def tunnelArn: Option[TunnelArn]
    def status: Option[zio.aws.iotsecuretunneling.model.TunnelStatus]
    def description: Option[Description]
    def createdAt: Option[DateType]
    def lastUpdatedAt: Option[DateType]
    def getTunnelId: ZIO[Any, AwsError, TunnelId] =
      AwsError.unwrapOptionField("tunnelId", tunnelId)
    def getTunnelArn: ZIO[Any, AwsError, TunnelArn] =
      AwsError.unwrapOptionField("tunnelArn", tunnelArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotsecuretunneling.model.TunnelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
  ) extends zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly {
    override val tunnelId: Option[TunnelId] = scala
      .Option(impl.tunnelId())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.TunnelId(value))
    override val tunnelArn: Option[TunnelArn] = scala
      .Option(impl.tunnelArn())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TunnelArn(value)
      )
    override val status: Option[zio.aws.iotsecuretunneling.model.TunnelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotsecuretunneling.model.TunnelStatus.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.Description(value)
      )
    override val createdAt: Option[DateType] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary
  ): zio.aws.iotsecuretunneling.model.TunnelSummary.ReadOnly = new Wrapper(impl)
}
