package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.{DeleteFlag, TunnelId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CloseTunnelRequest(
    tunnelId: TunnelId,
    delete: Option[DeleteFlag] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelRequest = {
    import CloseTunnelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelRequest
      .builder()
      .tunnelId(TunnelId.unwrap(tunnelId): java.lang.String)
      .optionallyWith(
        delete.map(value => DeleteFlag.unwrap(value): java.lang.Boolean)
      )(_.delete)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.CloseTunnelRequest.ReadOnly =
    zio.aws.iotsecuretunneling.model.CloseTunnelRequest.wrap(buildAwsValue())
}
object CloseTunnelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.CloseTunnelRequest =
      zio.aws.iotsecuretunneling.model
        .CloseTunnelRequest(tunnelId, delete.map(value => value))
    def tunnelId: TunnelId
    def delete: Option[DeleteFlag]
    def getTunnelId: ZIO[Any, Nothing, TunnelId] = ZIO.succeed(tunnelId)
    def getDelete: ZIO[Any, AwsError, DeleteFlag] =
      AwsError.unwrapOptionField("delete", delete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelRequest
  ) extends zio.aws.iotsecuretunneling.model.CloseTunnelRequest.ReadOnly {
    override val tunnelId: TunnelId =
      zio.aws.iotsecuretunneling.model.primitives.TunnelId(impl.tunnelId())
    override val delete: Option[DeleteFlag] = scala
      .Option(impl.delete())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.DeleteFlag(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.CloseTunnelRequest
  ): zio.aws.iotsecuretunneling.model.CloseTunnelRequest.ReadOnly = new Wrapper(
    impl
  )
}
