package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.DateType
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ConnectionState(
    status: Option[zio.aws.iotsecuretunneling.model.ConnectionStatus] = None,
    lastUpdatedAt: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionState = {
    import ConnectionState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly =
    zio.aws.iotsecuretunneling.model.ConnectionState.wrap(buildAwsValue())
}
object ConnectionState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.ConnectionState =
      zio.aws.iotsecuretunneling.model.ConnectionState(
        status.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def status: Option[zio.aws.iotsecuretunneling.model.ConnectionStatus]
    def lastUpdatedAt: Option[DateType]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.ConnectionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionState
  ) extends zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly {
    override val status
        : Option[zio.aws.iotsecuretunneling.model.ConnectionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.iotsecuretunneling.model.ConnectionStatus.wrap(value)
      )
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.ConnectionState
  ): zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly = new Wrapper(
    impl
  )
}
