package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.{
  ClientAccessToken,
  TunnelArn,
  TunnelId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OpenTunnelResponse(
    tunnelId: Option[TunnelId] = None,
    tunnelArn: Option[TunnelArn] = None,
    sourceAccessToken: Option[ClientAccessToken] = None,
    destinationAccessToken: Option[ClientAccessToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse = {
    import OpenTunnelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
      .builder()
      .optionallyWith(
        tunnelId.map(value => TunnelId.unwrap(value): java.lang.String)
      )(_.tunnelId)
      .optionallyWith(
        tunnelArn.map(value => TunnelArn.unwrap(value): java.lang.String)
      )(_.tunnelArn)
      .optionallyWith(
        sourceAccessToken.map(value =>
          ClientAccessToken.unwrap(value): java.lang.String
        )
      )(_.sourceAccessToken)
      .optionallyWith(
        destinationAccessToken.map(value =>
          ClientAccessToken.unwrap(value): java.lang.String
        )
      )(_.destinationAccessToken)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly =
    zio.aws.iotsecuretunneling.model.OpenTunnelResponse.wrap(buildAwsValue())
}
object OpenTunnelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.OpenTunnelResponse =
      zio.aws.iotsecuretunneling.model.OpenTunnelResponse(
        tunnelId.map(value => value),
        tunnelArn.map(value => value),
        sourceAccessToken.map(value => value),
        destinationAccessToken.map(value => value)
      )
    def tunnelId: Option[TunnelId]
    def tunnelArn: Option[TunnelArn]
    def sourceAccessToken: Option[ClientAccessToken]
    def destinationAccessToken: Option[ClientAccessToken]
    def getTunnelId: ZIO[Any, AwsError, TunnelId] =
      AwsError.unwrapOptionField("tunnelId", tunnelId)
    def getTunnelArn: ZIO[Any, AwsError, TunnelArn] =
      AwsError.unwrapOptionField("tunnelArn", tunnelArn)
    def getSourceAccessToken: ZIO[Any, AwsError, ClientAccessToken] =
      AwsError.unwrapOptionField("sourceAccessToken", sourceAccessToken)
    def getDestinationAccessToken: ZIO[Any, AwsError, ClientAccessToken] =
      AwsError.unwrapOptionField(
        "destinationAccessToken",
        destinationAccessToken
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
  ) extends zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly {
    override val tunnelId: Option[TunnelId] = scala
      .Option(impl.tunnelId())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.TunnelId(value))
    override val tunnelArn: Option[TunnelArn] = scala
      .Option(impl.tunnelArn())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TunnelArn(value)
      )
    override val sourceAccessToken: Option[ClientAccessToken] = scala
      .Option(impl.sourceAccessToken())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.ClientAccessToken(value)
      )
    override val destinationAccessToken: Option[ClientAccessToken] = scala
      .Option(impl.destinationAccessToken())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.ClientAccessToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.OpenTunnelResponse
  ): zio.aws.iotsecuretunneling.model.OpenTunnelResponse.ReadOnly = new Wrapper(
    impl
  )
}
