package zio.aws.iotsecuretunneling.model
import zio.aws.iotsecuretunneling.model.primitives.{
  DateType,
  Description,
  TunnelArn,
  TunnelId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Tunnel(
    tunnelId: Option[TunnelId] = None,
    tunnelArn: Option[TunnelArn] = None,
    status: Option[zio.aws.iotsecuretunneling.model.TunnelStatus] = None,
    sourceConnectionState: Option[
      zio.aws.iotsecuretunneling.model.ConnectionState
    ] = None,
    destinationConnectionState: Option[
      zio.aws.iotsecuretunneling.model.ConnectionState
    ] = None,
    description: Option[Description] = None,
    destinationConfig: Option[
      zio.aws.iotsecuretunneling.model.DestinationConfig
    ] = None,
    timeoutConfig: Option[zio.aws.iotsecuretunneling.model.TimeoutConfig] =
      None,
    tags: Option[Iterable[zio.aws.iotsecuretunneling.model.Tag]] = None,
    createdAt: Option[DateType] = None,
    lastUpdatedAt: Option[DateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel = {
    import Tunnel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
      .builder()
      .optionallyWith(
        tunnelId.map(value => TunnelId.unwrap(value): java.lang.String)
      )(_.tunnelId)
      .optionallyWith(
        tunnelArn.map(value => TunnelArn.unwrap(value): java.lang.String)
      )(_.tunnelArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        sourceConnectionState.map(value => value.buildAwsValue())
      )(_.sourceConnectionState)
      .optionallyWith(
        destinationConnectionState.map(value => value.buildAwsValue())
      )(_.destinationConnectionState)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(destinationConfig.map(value => value.buildAwsValue()))(
        _.destinationConfig
      )
      .optionallyWith(timeoutConfig.map(value => value.buildAwsValue()))(
        _.timeoutConfig
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly =
    zio.aws.iotsecuretunneling.model.Tunnel.wrap(buildAwsValue())
}
object Tunnel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotsecuretunneling.model.Tunnel =
      zio.aws.iotsecuretunneling.model.Tunnel(
        tunnelId.map(value => value),
        tunnelArn.map(value => value),
        status.map(value => value),
        sourceConnectionState.map(value => value.asEditable),
        destinationConnectionState.map(value => value.asEditable),
        description.map(value => value),
        destinationConfig.map(value => value.asEditable),
        timeoutConfig.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def tunnelId: Option[TunnelId]
    def tunnelArn: Option[TunnelArn]
    def status: Option[zio.aws.iotsecuretunneling.model.TunnelStatus]
    def sourceConnectionState
        : Option[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly]
    def destinationConnectionState
        : Option[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly]
    def description: Option[Description]
    def destinationConfig
        : Option[zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly]
    def timeoutConfig
        : Option[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly]
    def tags: Option[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]]
    def createdAt: Option[DateType]
    def lastUpdatedAt: Option[DateType]
    def getTunnelId: ZIO[Any, AwsError, TunnelId] =
      AwsError.unwrapOptionField("tunnelId", tunnelId)
    def getTunnelArn: ZIO[Any, AwsError, TunnelArn] =
      AwsError.unwrapOptionField("tunnelArn", tunnelArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotsecuretunneling.model.TunnelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSourceConnectionState: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly
    ] =
      AwsError.unwrapOptionField("sourceConnectionState", sourceConnectionState)
    def getDestinationConnectionState: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationConnectionState",
      destinationConnectionState
    )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("destinationConfig", destinationConfig)
    def getTimeoutConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly
    ] = AwsError.unwrapOptionField("timeoutConfig", timeoutConfig)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.iotsecuretunneling.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
  ) extends zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly {
    override val tunnelId: Option[TunnelId] = scala
      .Option(impl.tunnelId())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.TunnelId(value))
    override val tunnelArn: Option[TunnelArn] = scala
      .Option(impl.tunnelArn())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.TunnelArn(value)
      )
    override val status: Option[zio.aws.iotsecuretunneling.model.TunnelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotsecuretunneling.model.TunnelStatus.wrap(value))
    override val sourceConnectionState
        : Option[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly] =
      scala
        .Option(impl.sourceConnectionState())
        .map(value =>
          zio.aws.iotsecuretunneling.model.ConnectionState.wrap(value)
        )
    override val destinationConnectionState
        : Option[zio.aws.iotsecuretunneling.model.ConnectionState.ReadOnly] =
      scala
        .Option(impl.destinationConnectionState())
        .map(value =>
          zio.aws.iotsecuretunneling.model.ConnectionState.wrap(value)
        )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.iotsecuretunneling.model.primitives.Description(value)
      )
    override val destinationConfig
        : Option[zio.aws.iotsecuretunneling.model.DestinationConfig.ReadOnly] =
      scala
        .Option(impl.destinationConfig())
        .map(value =>
          zio.aws.iotsecuretunneling.model.DestinationConfig.wrap(value)
        )
    override val timeoutConfig
        : Option[zio.aws.iotsecuretunneling.model.TimeoutConfig.ReadOnly] =
      scala
        .Option(impl.timeoutConfig())
        .map(value =>
          zio.aws.iotsecuretunneling.model.TimeoutConfig.wrap(value)
        )
    override val tags
        : Option[List[zio.aws.iotsecuretunneling.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotsecuretunneling.model.Tag.wrap(item)
        }.toList
      )
    override val createdAt: Option[DateType] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
    override val lastUpdatedAt: Option[DateType] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.iotsecuretunneling.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotsecuretunneling.model.Tunnel
  ): zio.aws.iotsecuretunneling.model.Tunnel.ReadOnly = new Wrapper(impl)
}
