package zio.aws.iotroborunner.model
import zio.aws.iotroborunner.model.primitives.{
  WorkerFleetGenericIdentifier,
  PaginationToken,
  ListWorkersPageSize,
  SiteGenericIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkersRequest(
    site: SiteGenericIdentifier,
    maxResults: Optional[ListWorkersPageSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    fleet: Optional[WorkerFleetGenericIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest = {
    import ListWorkersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest
      .builder()
      .site(SiteGenericIdentifier.unwrap(site): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListWorkersPageSize.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        fleet.map(value =>
          WorkerFleetGenericIdentifier.unwrap(value): java.lang.String
        )
      )(_.fleet)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.ListWorkersRequest.ReadOnly =
    zio.aws.iotroborunner.model.ListWorkersRequest.wrap(buildAwsValue())
}
object ListWorkersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListWorkersRequest =
      zio.aws.iotroborunner.model.ListWorkersRequest(
        site,
        maxResults.map(value => value),
        nextToken.map(value => value),
        fleet.map(value => value)
      )
    def site: SiteGenericIdentifier
    def maxResults: Optional[ListWorkersPageSize]
    def nextToken: Optional[PaginationToken]
    def fleet: Optional[WorkerFleetGenericIdentifier]
    def getSite: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(site)
    def getMaxResults: ZIO[Any, AwsError, ListWorkersPageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleet: ZIO[Any, AwsError, WorkerFleetGenericIdentifier] =
      AwsError.unwrapOptionField("fleet", fleet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest
  ) extends zio.aws.iotroborunner.model.ListWorkersRequest.ReadOnly {
    override val site: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.site())
    override val maxResults: Optional[ListWorkersPageSize] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.iotroborunner.model.primitives.ListWorkersPageSize(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
    override val fleet: Optional[WorkerFleetGenericIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleet())
        .map(value =>
          zio.aws.iotroborunner.model.primitives
            .WorkerFleetGenericIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkersRequest
  ): zio.aws.iotroborunner.model.ListWorkersRequest.ReadOnly = new Wrapper(impl)
}
