package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier
import scala.jdk.CollectionConverters._
final case class GetSiteRequest(id: SiteGenericIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.GetSiteRequest = {
    import GetSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.GetSiteRequest
      .builder()
      .id(SiteGenericIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.GetSiteRequest.ReadOnly =
    zio.aws.iotroborunner.model.GetSiteRequest.wrap(buildAwsValue())
}
object GetSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.GetSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.GetSiteRequest =
      zio.aws.iotroborunner.model.GetSiteRequest(id)
    def id: SiteGenericIdentifier
    def getId: ZIO[Any, Nothing, SiteGenericIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetSiteRequest
  ) extends zio.aws.iotroborunner.model.GetSiteRequest.ReadOnly {
    override val id: SiteGenericIdentifier =
      zio.aws.iotroborunner.model.primitives.SiteGenericIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.GetSiteRequest
  ): zio.aws.iotroborunner.model.GetSiteRequest.ReadOnly = new Wrapper(impl)
}
