package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListWorkerFleetsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workerFleets: Optional[Iterable[zio.aws.iotroborunner.model.WorkerFleet]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse = {
    import ListWorkerFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workerFleets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workerFleets)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly =
    zio.aws.iotroborunner.model.ListWorkerFleetsResponse.wrap(buildAwsValue())
}
object ListWorkerFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.ListWorkerFleetsResponse =
      zio.aws.iotroborunner.model.ListWorkerFleetsResponse(
        nextToken.map(value => value),
        workerFleets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def workerFleets
        : Optional[List[zio.aws.iotroborunner.model.WorkerFleet.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkerFleets: ZIO[Any, AwsError, List[
      zio.aws.iotroborunner.model.WorkerFleet.ReadOnly
    ]] = AwsError.unwrapOptionField("workerFleets", workerFleets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse
  ) extends zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.iotroborunner.model.primitives.PaginationToken(value)
      )
    override val workerFleets
        : Optional[List[zio.aws.iotroborunner.model.WorkerFleet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workerFleets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotroborunner.model.WorkerFleet.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse
  ): zio.aws.iotroborunner.model.ListWorkerFleetsResponse.ReadOnly =
    new Wrapper(impl)
}
