package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotroborunner.model.primitives.{
  UpdatedAtTimestamp,
  CreatedAtTimestamp,
  DestinationId,
  DestinationArn
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateDestinationResponse(
    arn: DestinationArn,
    id: DestinationId,
    createdAt: CreatedAtTimestamp,
    updatedAt: UpdatedAtTimestamp,
    state: zio.aws.iotroborunner.model.DestinationState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.CreateDestinationResponse = {
    import CreateDestinationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.CreateDestinationResponse
      .builder()
      .arn(DestinationArn.unwrap(arn): java.lang.String)
      .id(DestinationId.unwrap(id): java.lang.String)
      .createdAt(CreatedAtTimestamp.unwrap(createdAt): Instant)
      .updatedAt(UpdatedAtTimestamp.unwrap(updatedAt): Instant)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly =
    zio.aws.iotroborunner.model.CreateDestinationResponse.wrap(buildAwsValue())
}
object CreateDestinationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.CreateDestinationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.CreateDestinationResponse =
      zio.aws.iotroborunner.model.CreateDestinationResponse(
        arn,
        id,
        createdAt,
        updatedAt,
        state
      )
    def arn: DestinationArn
    def id: DestinationId
    def createdAt: CreatedAtTimestamp
    def updatedAt: UpdatedAtTimestamp
    def state: zio.aws.iotroborunner.model.DestinationState
    def getArn: ZIO[Any, Nothing, DestinationArn] = ZIO.succeed(arn)
    def getId: ZIO[Any, Nothing, DestinationId] = ZIO.succeed(id)
    def getCreatedAt: ZIO[Any, Nothing, CreatedAtTimestamp] =
      ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, UpdatedAtTimestamp] =
      ZIO.succeed(updatedAt)
    def getState
        : ZIO[Any, Nothing, zio.aws.iotroborunner.model.DestinationState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateDestinationResponse
  ) extends zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly {
    override val arn: DestinationArn =
      zio.aws.iotroborunner.model.primitives.DestinationArn(impl.arn())
    override val id: DestinationId =
      zio.aws.iotroborunner.model.primitives.DestinationId(impl.id())
    override val createdAt: CreatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .CreatedAtTimestamp(impl.createdAt())
    override val updatedAt: UpdatedAtTimestamp =
      zio.aws.iotroborunner.model.primitives
        .UpdatedAtTimestamp(impl.updatedAt())
    override val state: zio.aws.iotroborunner.model.DestinationState =
      zio.aws.iotroborunner.model.DestinationState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.CreateDestinationResponse
  ): zio.aws.iotroborunner.model.CreateDestinationResponse.ReadOnly =
    new Wrapper(impl)
}
