package zio.aws.iotroborunner.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotroborunner.model.primitives.{
  VendorAdditionalFixedPropertiesJson,
  VendorAdditionalTransientPropertiesJson,
  VendorWorkerIpAddress,
  VendorWorkerId
}
import scala.jdk.CollectionConverters._
final case class VendorProperties(
    vendorWorkerId: VendorWorkerId,
    vendorWorkerIpAddress: Optional[VendorWorkerIpAddress] = Optional.Absent,
    vendorAdditionalTransientProperties: Optional[
      VendorAdditionalTransientPropertiesJson
    ] = Optional.Absent,
    vendorAdditionalFixedProperties: Optional[
      VendorAdditionalFixedPropertiesJson
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotroborunner.model.VendorProperties = {
    import VendorProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotroborunner.model.VendorProperties
      .builder()
      .vendorWorkerId(VendorWorkerId.unwrap(vendorWorkerId): java.lang.String)
      .optionallyWith(
        vendorWorkerIpAddress.map(value =>
          VendorWorkerIpAddress.unwrap(value): java.lang.String
        )
      )(_.vendorWorkerIpAddress)
      .optionallyWith(
        vendorAdditionalTransientProperties.map(value =>
          VendorAdditionalTransientPropertiesJson.unwrap(
            value
          ): java.lang.String
        )
      )(_.vendorAdditionalTransientProperties)
      .optionallyWith(
        vendorAdditionalFixedProperties.map(value =>
          VendorAdditionalFixedPropertiesJson.unwrap(value): java.lang.String
        )
      )(_.vendorAdditionalFixedProperties)
      .build()
  }
  def asReadOnly: zio.aws.iotroborunner.model.VendorProperties.ReadOnly =
    zio.aws.iotroborunner.model.VendorProperties.wrap(buildAwsValue())
}
object VendorProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotroborunner.model.VendorProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotroborunner.model.VendorProperties =
      zio.aws.iotroborunner.model.VendorProperties(
        vendorWorkerId,
        vendorWorkerIpAddress.map(value => value),
        vendorAdditionalTransientProperties.map(value => value),
        vendorAdditionalFixedProperties.map(value => value)
      )
    def vendorWorkerId: VendorWorkerId
    def vendorWorkerIpAddress: Optional[VendorWorkerIpAddress]
    def vendorAdditionalTransientProperties
        : Optional[VendorAdditionalTransientPropertiesJson]
    def vendorAdditionalFixedProperties
        : Optional[VendorAdditionalFixedPropertiesJson]
    def getVendorWorkerId: ZIO[Any, Nothing, VendorWorkerId] =
      ZIO.succeed(vendorWorkerId)
    def getVendorWorkerIpAddress: ZIO[Any, AwsError, VendorWorkerIpAddress] =
      AwsError.unwrapOptionField("vendorWorkerIpAddress", vendorWorkerIpAddress)
    def getVendorAdditionalTransientProperties
        : ZIO[Any, AwsError, VendorAdditionalTransientPropertiesJson] =
      AwsError.unwrapOptionField(
        "vendorAdditionalTransientProperties",
        vendorAdditionalTransientProperties
      )
    def getVendorAdditionalFixedProperties
        : ZIO[Any, AwsError, VendorAdditionalFixedPropertiesJson] =
      AwsError.unwrapOptionField(
        "vendorAdditionalFixedProperties",
        vendorAdditionalFixedProperties
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotroborunner.model.VendorProperties
  ) extends zio.aws.iotroborunner.model.VendorProperties.ReadOnly {
    override val vendorWorkerId: VendorWorkerId =
      zio.aws.iotroborunner.model.primitives
        .VendorWorkerId(impl.vendorWorkerId())
    override val vendorWorkerIpAddress: Optional[VendorWorkerIpAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorWorkerIpAddress())
        .map(value =>
          zio.aws.iotroborunner.model.primitives.VendorWorkerIpAddress(value)
        )
    override val vendorAdditionalTransientProperties
        : Optional[VendorAdditionalTransientPropertiesJson] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vendorAdditionalTransientProperties())
        .map(value =>
          zio.aws.iotroborunner.model.primitives
            .VendorAdditionalTransientPropertiesJson(value)
        )
    override val vendorAdditionalFixedProperties
        : Optional[VendorAdditionalFixedPropertiesJson] = zio.aws.core.internal
      .optionalFromNullable(impl.vendorAdditionalFixedProperties())
      .map(value =>
        zio.aws.iotroborunner.model.primitives
          .VendorAdditionalFixedPropertiesJson(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotroborunner.model.VendorProperties
  ): zio.aws.iotroborunner.model.VendorProperties.ReadOnly = new Wrapper(impl)
}
